/*
 * AY_Emul_210_2ch_2313.asm
 *
 *  Created: 20.01.2016 14:55:05
 *  Author: EvgenRU
 */ 
// .DEVICE ATTuny2313
.include "tn2313def.inc"
; FLASH_SIZE=2KB
; SRAM_START=0x60
;---------------------------------------
	.cseg
	.org	0x0000
;---------------------------------------
.def OutA	= r0
.def OutC	= r1
.def TabP	= r2
.def TabE	= r3
.def C18	= r4
.def CFF	= r5
.def NoiseAddon	= r6
.def C01	= r7
.def CC0	= r8
.def C30	= r9
.def EChange	= r10
.def BusEx	= r11
.def CntN	= r12
.def SREGSave	= r13
.def RNGL	= r14
.def RNGH	= r15
.def TMP	= r16
.def EVal	= r17
.def TNLevel	= r18
.def BusData	= r19
.def CntAL	= r20
.def CntAH	= r21
.def CntBL	= r22
.def CntBH	= r23
.def CntCL	= r24
.def CntCH	= r25
.def ADDR	= r30

; bit numbers:
.equ	b0	= 0x00
.equ	b1	= 0x01
.equ	b2	= 0x02
.equ	b3	= 0x03
.equ	b4	= 0x04
.equ	b5	= 0x05
.equ	b6	= 0x06
.equ	b7	= 0x07


;==========================================================

_PSTART:	; interrupts vector table
	rjmp	_RESET
	rjmp	_INT0
	rjmp	_INT1
	reti
	reti
	reti
	reti
	rjmp	_USART_RX_COMPLETE


VolTab1:
	.db 0,1,2,3,5,6,8,12,14,18,21,23,27,31,36,41
VolTab2:
	.db 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,21,22,23,25,27,29,31,33,36,39,41,44
RegsMask:
	.db 0xFF,0x0F,0xFF,0x0F,0xFF,0x0F,0x1F,0xFF,0x1F,0x1F,0x1F,0xFF,0xFF,0x0F,0xFF,0xFF

;==========================================================
_INT1:
	sbis	PIND,b2			; skip jump if BC1 = 1
	rjmp	WRITE_REG
LATCH_REG_ADDR:
	// LATCH ADDRESS MODE (BC1=1, BDIR=1) ===========================
	in	BusEx,PIND		; PinD -> BusEx
	in	ADDR,PINB		; PinB -> ADDR
	in	SREGSave,SREG
	andi	ADDR,0x0F		; ADDR &= 0x0F
	bst	BusEx,b4		; BusEx.4 -> ADDR.3
	bld	ADDR,b3
	ori	ADDR,0x90		; ADDR |= 0x90
	ld	BusData,Z		; [Z] -> BusData
	out	PORTB,BusData		; BusData -> PortB
	lsl	BusData			; BusData <<= 1;
	out	PORTD,BusData		; BusData -> PortD
	out	SREG,SREGSave
	out	EIFR,CC0		; Reset Ext. Interrupt Flags
	reti
WRITE_REG:
	// WRITE REGISTER MODE (BC=0, BDIR=1) ===========================
	in	BusEx,PIND
	in	BusData,PINB
	bst	BusEx,b4
	bld	BusData,b3
	bst	BusEx,b5
	bld	BusData,b4
	st	Z,BusData
	ldi	BusData,0x9D
	cpse	ADDR,BusData 		; skip next if registars are equal
	mov	EChange,C01
	reti
;==========================================================
_INT0:
	sbic	PIND,b3			; skip jump if BDIR = 0
	rjmp	LATCH_REG_ADDR
	// READ MODE (BC1=1, BDIR=0) ====================================
	out	DDRB,CFF
	out	DDRD,C30
	nop
	nop
	out	DDRD,zh
	out	DDRB,C18
	reti

;==========================================================
_USART_RX_COMPLETE:
	in	BusData,UDR
	sbrs	ADDR,b5
	rjmp	RECV_REG_VALUE
	sbrc	BusData,b7
	rjmp	USART_SYNC
	mov	ADDR,BusData
	in	SREGSave,SREG
	ori	ADDR,0x90
	out	SREG,SREGSave
	reti
USART_SYNC:
	ldi	ADDR,0x60
	reti
RECV_REG_VALUE:
	in	SREGSave,SREG
	ldd	BusEx,Z+0x10		; apply registers mask
	and	BusData,BusEx
	st	Z,BusData
	ldi	BusData,0x9D
	cpse	ADDR,BusData 		; skip next if registars are equal
	mov	EChange,C01
	ldi	ADDR,0x60
	out	SREG,SREGSave
	reti

;==========================================================
_RESET:
	// init stack pointer
	ldi	TMP,0xDF
	out	SPL,TMP
	
	// disable AC
	ldi	TMP,0x81
	out	ACSR,TMP
	
	// 1 -> PUD
	in	TMP,MCUCR
	ori	TMP,0x80
	out	MCUCR,TMP

	ldi	r16,0x01
	mov	C01,r16
	ldi	r16,0x18
	mov	C18,r16
	ldi	r16,0xC0
	mov	CC0,r16
	ldi	r16,0x30
	mov	C30,r16
	ldi	r16,0xFF
	mov	CFF,r16
	mov	RNGL,r16
	mov	RNGH,r16
	clr	EChange

	// clear SRAM 0x60-0xD0
	clr	r16
	clr	zh
	ldi	r18,0x70
	ldi	zl,0x60
L0067:
	st	Z+,r16
	dec	r18
	brne	L0067

	// load volume table for envelopes to SRAM 0x60, 32 bytes
	sts	D009E,TMP
	sts	D009F,TMP
	clr	xh
	ldi	xl,0x60
	ldi 	zl, low(2*VolTab2)
	ldi 	zh, high(2*VolTab2)
	ldi	r18,0x20
L0073:
	lpm	r16,Z+
	st	X+,TMP
	dec	r18
	brne	L0073

	// load volume table for amplitudes to SRAM 0x80, 16 bytes
	ldi	xl,0x80	; xh already cleared
	ldi 	zl, low(2*VolTab1)
	ldi 	zh, high(2*VolTab1)
	ldi	r18,0x10
L007C:
	lpm	r16,Z+
	st	X+,r16
	dec	r18
	brne	L007C

	// load register masks to SRAM 0x80, 16 bytes
	ldi	xl,0xA0
	ldi 	zl, low(2*RegsMask)
	ldi 	zh, high(2*RegsMask)
	ldi	r18,0x10
L0085:
	lpm	r16,Z+
	st	X+,r16
	dec	r18
	brne	L0085

	clr	zh
	clr	yh

	// get byte 0 from EEPROM
	out	EEAR,zh
	sbi	EECR,b0
	in	r16,EEDR
	// skip USART initialization if zero
	cp	r16,zh
	breq	NO_USART

	// USART setup
	ldi	r16,0x00
	out	UBRRH,r16
	ldi	r16,0x06
	out	UCSRC,r16
	ldi	r16,0x02
	out	UCSRA,r16
	ldi	r16,0x90
	out	UCSRB,r16
	// get Baud Rate value from byte 3 in EEPROM
	ldi	r16,0x03
	out	EEAR,r16
	sbi	EECR,b0
	in	r18,EEDR
	out	UBRRL,r18

NO_USART:
	// timer 1 initialization
	sbi	DDRB,b3
	sbi	DDRB,b4
	ldi	r16,0xA2
	out	TCCR1A,r16
	ldi	r16,0x19
	out	TCCR1B,r16

	// set ICR value (PWM speed) from byte 2 in EEPROM
	ldi	r16,0x02
	out	EEAR,r16
	sbi	EECR,b0
	in	r18,EEDR
	out	ICR1H,r31
	out	ICR1L,r18

	// External interrupts initialization, if byte 1 in EEPROM is zero then skip initialization
	out	EEAR,C01
	sbi	EECR,b0
	in	r16,EEDR
	cp	r16,r31
	breq	NO_EXT_INT

	ldi	r16,0x0F
	out	MCUCR,r16
	ldi	r16,0xC0
	out	EIFR,r16
	out	GIMSK,r16
NO_EXT_INT:
	// clear PWM values
	out	OCR1AH,ZH
	out	OCR1BH,ZH
	out	OCR1AL,ZH
	out	OCR1BL,ZH

	// initialize global variables
	clr	BusEx
	ldi	ADDR,0xB0
	ldi	TNLevel,0x28
	clr	OutA
	clr	OutC
	mov	TabP,CC0
	clr	TabE
	clr	BusData
	clr	NoiseAddon
	clr	CntN
	clr	CntAL
	clr	CntAH
	mov	CntBL,CntAL
	mov	CntBH,CntAH
	mov	CntCL,CntAL
	mov	CntCH,CntAH
	mov	xl,CntAL
	mov	xh,CntAH
	clr	EVal
	sei

_LOOP:
	// MAIN LOOP
	// check timer1 overflow flag TOV1
	in	TMP,TIFR
	sbrs	TMP,b7
	rjmp	_LOOP		; jump if not set

	out	TIFR,CC0	; clear timer overflow flag


	/////////////////////////////////////////////////////////////////////////////////////
	/// ENVELOPE GENERATOR
	/////////////////////////////////////////////////////////////////////////////////////
	cp	EChange,zh	; check if envelope shape register changed
	breq	NO_ENVELOPE_CHANGED

	lds	TabE,D009D	; load envelope shape register
	// initialize envelope generator
	mov	TabP,C01
	clr	EChange		; clear envelope changed flag
	lds	xl,D009B	; initialize envelope counter
	lds	xh,D009C
	// initialize envelope volume value
	clr	EVal
	sbrs	TabE,b2
	ldi	EVal,0x2C
	rjmp	ENVELOPE_GENERATOR_END
NO_ENVELOPE_CHANGED:
	sbrc	TabP,b7		; check if envelope generator is disabled
	rjmp	ENVELOPE_GENERATOR_END

	sbiw	X,0x01	; decrease envelope counter
	// if CntE <=0 do init envelope generator
	brcs	INIT_ENVELOPE_GENERATOR	
	brne	ENVELOPE_GENERATOR_END

INIT_ENVELOPE_GENERATOR:
	lds	xl,D009B	; initialize envelope counter
	lds	xh,D009C

	sbrs	TabP,b5		; check for end of envelope period
	rjmp	ENVELOPE_PERIOD_ACTIVE

	// initialize envelope period
	sbrc	TabE,b3		; check CONTINUE bit
	rjmp	NO_CONT
	
	clr	EVal		; set envelope value to 0
	or	TabP,CC0	; disable envelope generator
	rjmp	ENVELOPE_GENERATOR_END
NO_CONT:
	sbrc	TabE,b0		; check HOLD bit
	rjmp	ENV_HOLD

	// init new envelope period
	clr	TabP
	ldi	yl,0x04
	sbrc	TabE,b1		; check ALTERNATE bit
	eor	TabE,yl		; invert ATTACK bit if ALTERNATE is set
	rjmp	ENVELOPE_PERIOD_ACTIVE
ENV_HOLD:
	or	TabP,CC0	; disable envelope generator
	clr	yl
	mov	TMP,TabE
	inc	TMP		; TMP + 2 same as TMP.2^TMP.1
	inc	TMP
	sbrc	TMP,b2		; check if envelope bits 1 and 2 is differ
	ldi	yl,0x1F		; set max value if differ
	rjmp	ENV_TO_VOL

ENVELOPE_PERIOD_ACTIVE:
	mov	yl,TabP
	ldi	EVal,0x1F
	sbrs	TabE,b2		; invert envelope if ATTACK bit is not set
	eor	r28,EVal
	inc	TabP		; increase envelope period counter value
ENV_TO_VOL:
	// convert envelope value to volume
	ori	yl,0x60
	ldd	EVal,Y+0x00	; read volume value from SRAM

ENVELOPE_GENERATOR_END:
	/////////////////////////////////////////////////////////////////////////////////////


	/////////////////////////////////////////////////////////////////////////////////////
	/// NOISE GENERATOR
	/////////////////////////////////////////////////////////////////////////////////////
	dec	CntN		; decrease noise period counter
	brpl	NO_NOISE_CHANGED

	lds	CntN,D0096	; set noise period value
	dec	CntN		; decrease noise period counter
	// pseudo random number generator
	mov	TMP,RNGL
	swap	TMP		; swap nibbles
	lsr	TMP		; shift left
	eor	TMP,RNGL	; xor
	lsr	NoiseAddon	; move additional bit to carry flag
	ror	RNGH		; rotate right through carry
	ror	RNGL		; rotate right through carry
	brcc	NO_NLVL_CHANGED	; invert noise level Carry flag is set
	ldi	yl,0x38
	eor	TNLevel,yl
NO_NLVL_CHANGED:
	 sbrs	TMP,b3		; if bits 0 and 3 differ skip next line
	 or	NoiseAddon,C01	; set random generator addirional bit
NO_NOISE_CHANGED:
	/////////////////////////////////////////////////////////////////////////////////////


	/////////////////////////////////////////////////////////////////////////////////////
	/// TONE GENERATOR
	/////////////////////////////////////////////////////////////////////////////////////

	// Channel A
	subi	CntAL,0x01	; CntA - 1
	sbci	CntAH,0x00
	brpl	CNTA_POSITIVE	; if CntA >= 0 goto CNTA_POSITIVE
	lds	CntAL,D0090	; update channel A tone period counter
	lds	CntAH,D0091
	subi	CntAL,0x01	; CntA - 1
	sbci	CntAH,0x00
	eor	TNLevel,C01	; TNLevel xor 1 (change logical level of channel A)
CNTA_POSITIVE:

	// Channel B
	subi	CntBL,0x01	; CntB - 1
	sbci	CntBH,0x00
	brpl	CNTB_POSITIVE	; if CntB >= 0 goto CNTB_POSITIVE
	lds	CntBL,D0092	; update channel B tone period counter
	lds	CntBH,D0093
	subi	CntBL,0x01	; CntB - 1
	sbci	CntBH,0x00
	ldi	yl,0x02
	eor	TNLevel,yl	; TNLevel xor 2 (change logical level of channel B)
CNTB_POSITIVE:

	// Channel C
	sbiw	CntCL,0x01	; CntC - 1
	brpl	CNTC_POSITIVE	; if CntC >= 0 goto CNTC_POSITIVE
;	-----		branch on last line
	lds	CntCL,D0094	; update channel C tone period counter
	lds	CntCH,D0095
	sbiw	CntCL,0x01	; CntC - 1
	ldi	yl,0x04
	eor	TNLevel,yl	; TNLevel xor 4 (change logical level of channel C)
CNTC_POSITIVE:
	/////////////////////////////////////////////////////////////////////////////////////


	/////////////////////////////////////////////////////////////////////////////////////
	/// MIXER
	/////////////////////////////////////////////////////////////////////////////////////
	lds	TMP,D0097	; Load Mixer Register from SRAM
	or	TMP,TNLevel	; Mixer formula = (Mixer Register Tone | TNLevel Tone) & (Mixer Register Noise | TNLevel Noise)
	mov	yl,TMP
	lsl	yl
	swap	yl
	and	TMP,yl
	/////////////////////////////////////////////////////////////////////////////////////


	/////////////////////////////////////////////////////////////////////////////////////
	/// AMPLITUDE CONTROL
	/////////////////////////////////////////////////////////////////////////////////////

	// Channel A
	lds	yl,D0098	; Load Channel A Amplitude register
	ori	yl,0x80		; Volume table offset in SRAM is 0x80
	mov	OutA,EVal	; set envelope volume as default value
	sbrs	yl,b4		; if bit 4 is not set in amplitude register then translate it to volume
	ldd	OutA,Y+0x00
	sbrs	TMP,b0		; if channel is disabled in mixer - set volume to zero
	clr	OutA

	// Channel B
	lds	yl,D009A	; Load Channel B Amplitude register
	ori	yl,0x80		; Volume table offset in SRAM is 0x80
	mov	OutC,EVal	; set envelope volume as default value
	sbrs	yl,b4		; if bit 4 is not set in amplitude register then translate it to volume
	ldd	OutC,Y+0x00
	sbrs	TMP,b2		; if channel is disabled in mixer - set volume to zero
	clr	OutC

	// Channel C
	sbrs	TMP,b1
	rjmp	CHANNEL_C_DISABLED	; jump if channel C is disabled in mixer
	lds	yl,D0099
	ori	yl,0x80		; Volume table offset in SRAM is 0x80
	mov	TMP,EVal	; set envelope volume as default value
	sbrs	yl,b4		; if bit 4 is not set in amplitude register then translate it to volume
	ldd	TMP,Y+0x00

	lsr	TMP		; TMP = TMP / 2
	add	OutA,TMP	; ADD TMP to volume of channel B and C
	add	OutC,TMP
CHANNEL_C_DISABLED:
	out	OCR1AL,OutA	; Update PWM counters
	out	OCR1BL,OutC
	rjmp	_LOOP


;---------------------------------------
	.dseg
	.org	0x0090
;
D0090:			; AY REGISTER 0
	.byte	1
D0091:			; AY REGISTER 1
	.byte	1
D0092:			; AY REGISTER 2
	.byte	1
D0093:			; AY REGISTER 3
	.byte	1
D0094:			; AY REGISTER 4
	.byte	1
D0095:			; AY REGISTER 5
	.byte	1
D0096:			; AY REGISTER 6
	.byte	1
D0097:			; AY REGISTER 7
	.byte	1
D0098:			; AY REGISTER 8
	.byte	1
D0099:			; AY REGISTER 9
	.byte	1
D009A:			; AY REGISTER 10
	.byte	1
D009B:			; AY REGISTER 11
	.byte	1
D009C:			; AY REGISTER 12
	.byte	1
D009D:			; AY REGISTER 13
	.byte	1
D009E:			; AY REGISTER 14
	.byte	1
D009F:			; AY REGISTER 15
	.byte	1


