unit Unit1; // AY-ATMega Player

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, CommPort, StdCtrls, ComCtrls, MMSystem;

type
  TForm1 = class(TForm)
    ComPort1: TComPort;
    ComboBox1: TComboBox;
    Button1: TButton;
    Button2: TButton;
    GroupBox1: TGroupBox;
    Button3: TButton;
    OpenDialog1: TOpenDialog;
    Button4: TButton;
    Button5: TButton;
    GroupBox2: TGroupBox;
    ProgressBar1: TProgressBar;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button3Click(Sender: TObject);
    procedure ComPort1ReceiveCallBack(Data: String);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

  AYRSize:Integer;
  AYRData:Array of Byte;
  AYRPos:Integer;
  AYROut:String[16];
  Playing:Boolean=False;
  uEventID:UINT;
  Errors:Integer;

Const
  AYRMute:String[16]=#$FF#$0F#$FF#$0F#$FF#$0F#$1F#$FF#$00#$00#$00#$FF#$FF#$00#$80#$7F;
  AYPlayerVersion:String='AY-ATMega Player Ver. 1.3';

function timeSetEvent(uDelay,uResolution: UINT; ipTimeProc: Pointer;
         dwUser: DWORD; fuEvent: UINT): Integer; stdcall;
function timeKillEvent(uID: UINT): Integer; stdcall;
procedure ProcTime(uID, msg: UINT; dwUse, dw1, dw2:DWORD); stdcall;

implementation

{$R *.dfm}

//    MM :
function timeSetEvent(uDelay,uResolution: UINT; ipTimeProc: Pointer;
         dwUser: DWORD; fuEvent: UINT): Integer; stdcall; external 'winmm.dll';

function timeKillEvent(uID: UINT): Integer; stdcall; external 'winmm.dll';

//  
procedure TForm1.FormCreate(Sender: TObject);
begin
Form1.Caption:=AYPlayerVersion;
EnumPorts( ComboBox1.Items );
if ComboBox1.Items.Count > 0 then
   ComboBox1.ItemIndex := 0; // show first available port
uEventID:=timeSetEvent(20,0,@ProcTime,0,TIME_PERIODIC);
if uEventID=0 then ShowMessage('Error Starting MM Timer');
end;

//  COM 
procedure TForm1.Button1Click(Sender: TObject);
begin
if ComboBox1.Items.Strings[0]='' then Exit;
ComboBox1.Enabled := false;
ComPort1.Port := ComboBox1.Items[ComboBox1.ItemIndex];
ComPort1.Open;
Button1.Enabled:=False;
Button2.Enabled:=True;
Button3.Enabled:=True;
Button4.Enabled:=AYRSize>0;
Button5.Enabled:=AYRSize>0;
end;

//  COM 
procedure TForm1.Button2Click(Sender: TObject);
begin
Button5.Click;// Stop
ComPort1.Close;
ComboBox1.Enabled := true;
Button1.Enabled:=True;
Button2.Enabled:=False;
Button3.Enabled:=False;
Button4.Enabled:=False;
Button5.Enabled:=False;
end;

//  
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
Button5.Click;// Stop
timeKillEvent(uEventID);
ComPort1.Free;
AYRData:=nil;
end;

//   
procedure TForm1.Button3Click(Sender: TObject);
Var
 AYR:File of Byte;
 i:Integer;
begin
OpenDialog1.InitialDir:=GetCurrentDir;
OpenDialog1.Title:='Open AY Registers Stream File...';
if OpenDialog1.Execute then
   Begin
   if not FileExists(OpenDialog1.FileName) then Exit;
   AssignFile(AYR,OpenDialog1.FileName);
   FileMode:=fmOpenRead;
   Button5.Click;// Stop
   {$I-}
   Reset(AYR);
   AYRSize:=FileSize(AYR);
   if AYRSize>=28 then
      Begin
      AYRSize:=(AYRSize div 14)*14;//     14
      SetLength(AYRData,AYRSize);
      for i:=0 to AYRSize-1 do Read(AYR,AYRData[i]);
      end
      else AYRData:=nil;
   CloseFile(AYR);
   if IOResult<>0 then Begin
                       ShowMessage('Error access file: Cannot open file!');
                       AYRSize:=0;
                       AYRData:=nil;
                       end;
   {$I+}
   if AYRSize<28 then Begin
                      Button4.Enabled:=False;
                      Button5.Enabled:=False;
                      AYRSize:=0;
                      end
                 else Begin
                      Button4.Enabled:=True;
                      Button5.Enabled:=True;
                      end;
   AYRPos:=0;
   Button4.Click;// Play
   end;
end;

//     COM 
procedure TForm1.ComPort1ReceiveCallBack(Data: String);
begin
// Not Use
end;

// MM .
procedure ProcTime(uID, msg: UINT; dwUse, dw1, dw2:DWORD); stdcall;
Var i:Integer;
Begin
if Form1.Button1.Enabled then Exit; //   COM  
if Playing then //        
   Begin
   Inc(AYRPos,14);
   if AYRPos>=(AYRSize-1) then AYRPos:=14;//     
   AYROut:='';
   for i:=0 to 13 do
       AYROut:=AYROut+Chr(AYRData[AYRPos+i]);
   AYROut:=AYROut+#$80#$7F;
   Form1.ComPort1.Send(AYROut);
   Form1.ProgressBar1.Position:=Round(100*AYRPos/AYRSize);
   end
   else Form1.ComPort1.Send(AYRMute); //   
end;

// Play
procedure TForm1.Button4Click(Sender: TObject);
begin
if AYRSize=0 then Exit;
Playing:=True;
end;

// Stop
procedure TForm1.Button5Click(Sender: TObject);
begin
Playing:=False;
AYRPos:=0;
ProgressBar1.Position:=0;
Refresh;
end;

end.
