.DEVICE ATmega8
.include "m8def.inc"

.cseg

.org	0x0000

.def OutA	=r0	;	     A
.def OutB	=r1	;	     B
.def OutC	=r2	;	     C
.def CntN	=r3	;	  
.def Const00	=r4	;	 0x00
.def UnLock	=r5	;	      (0x04)
.def DivN	=r6	;	   (AY-R6)
.def MixerABC	=r7	;	 (AY-R7)
.def ConstC0	=r8	;	 0xC0
.def Const3F	=r9	;	 0x3F
.def BusEx	=r10	;	  BusData
.def Const0F	=r11	;	 0x0F
.def TMP	=r12	;	   USART
.def EIndex	=r13	;	    ()
.def RNGL	=r14	;	 
.def RNGH	=r15	;	 
;		=r16	;	     
;		=r17	;	     _reset
;		=r18	;	     _reset
;		=r19	;	     
.def EVal	=r20	;	  ()
.def BusData	=r21	;	       
.def TabP	=r22	;	    
.def TNLevel	=r23	;	       
.def TMP2	=r24	;	  
.def ToneBits	=r25	;	     
.def CntEL	=r28	;	reg Y	
.def CntEH	=r29	;	reg Y	
.def ADDR	=r30	;	reg ZL


; io register addresses:
;
.equ	p20	= 0x20 // UBRRH/UCSRC
;

; bit numbers:
;
.equ	b0	= 0x00
.equ	b1	= 0x01
.equ	b2	= 0x02
.equ	b3	= 0x03
.equ	b4	= 0x04
.equ	b5	= 0x05
.equ	b6	= 0x06
.equ	b7	= 0x07

;------------------------------------------------------
; INTERRUPT VECTORS TABLE
;------------------------------------------------------
rjmp	_reset;
rjmp	INT_Interrupt
rjmp	INT_Interrupt
reti
reti
reti
reti
reti
rjmp	Timer1_interrupt
reti
reti
rjmp	USART_Receive_Complete


VolTab:
	.db 0,2,3,5,7,10,13,17,21,25,30,36,44,55,66,77
AYEnvTab:
	.db 0,0,0,2,0,1,0,3,1,1,1,3,1,0,1,2
EIndexes:
	.db 32,32,32,32,224,224,224,224,0,32,64,96,128,160,192,224

;------------------------------------------------------
INT_Interrupt:
	sbic	PIND,b3
	rjmp	L0028
	out	DDRC,Const3F
	out	DDRD,ConstC0
L001F:
	in	BusData,PIND
	sbrs	BusData,b2
	rjmp	L0025
	sbrc	BusData,b3
	rjmp	L0025
	rjmp	L001F
L0025:
	out	DDRC,Const00
	out	DDRD,Const00
	reti
L0028:
	in	BusEx,PIND
	in	BusData,PINC
	sbrs	BusEx,b2
	rjmp	L003C
	sbrc	BusData,b4
	rjmp	L003A
	sbrc	BusData,b5
	rjmp	L003A
	sbrc	BusEx,b6
	rjmp	L003A
	sbrc	BusEx,b7
	rjmp	L003A
	mov	ADDR,BusData
	ldd	BusData,Z+0x10
	out	PORTC,BusData
	and	BusData,ConstC0
	or	BusEx,BusData
	out	PORTD,BusEx
L003A:
	out	GIFR,ConstC0
	reti
L003C:
	out	PORTC,BusData
	out	PORTD,BusEx
	and	BusEx,ConstC0
	or	BusData,BusEx
	std	Z+0x10,BusData
	std	Z+0x30,Const0F
	reti
//---- INT Interrupt end -----------------------------

//----------------------------------------------------
// Program start -------------------------------------
//----------------------------------------------------
_reset:
	ldi	r16,0x5F
	out	SPL,r16
	ldi	r16,0x04
	out	SPH,r16
	ldi	r16,0x81
	out	ACSR,r16

	clr	Const00		; 0->Const00

	ldi	r16,0xC0
	mov	ConstC0,r16
	ldi	r16,0x3F
	mov	Const3F,r16
	ldi	r16,0x0F
	mov	Const0F,r16
	ldi	r16,0x04
	mov	UnLock,r16
	mov	XL,ConstC0

// SRAM Variables 0x60-0xC0 clear
	clr	XH	
L0055:
	st	X,XH
	dec	XL
	cpi	XL,0x60
	brcc	L0055
// Clear regs buffer in SRAM 0x210-0x250 (0x40 values)
	ldi	r18,0x40
	ldi	XL,0x10
	ldi	XH,0x02
L005C:
	st	X+,Const00
	dec	r18
	brne	L005C

// Move volume table to SRAM address 0x200
	// SRAM Address 0x0200
	clr	XL
	ldi	XH,0x02
	ldi ZL, low(2*VolTab)
	ldi ZH, high(2*VolTab)
	ldi	r18,0x10 	// 16 values
L0064:
	lpm	r16,Z+
	st	X+,r16
	dec	r18
	brne	L0064

// Move EIndexes table to SRAM address 0x240
	// SRAM Address 0x0240
	ldi	XL,0x40
	ldi ZL, low(2*EIndexes)
	ldi ZH, high(2*EIndexes)
	ldi	r18,0x10	// 16 values
L006D:
	lpm	r16,Z+
	st	X+,r16
	dec	r18
	brne	L006D

// Make Envelopes table in SRAM address 0x100, 256 values
	ldi	r18,0x10	// 16 = 8 envelopes x 2 periods
	// SRAM Address 0x0100
	clr	XL
	ldi	XH,0x01
	ldi ZL, low(2*AYEnvTab)
	ldi ZH, high(2*AYEnvTab)
L0076:
	lpm	YL,Z+
	ldi	YH,0x10
	cpse	YL,Const00
	rjmp	L007F
	ldi	TMP2,0x0F
L007B:
	st	X+,TMP2
	dec	TMP2
	dec	YH
	brne	L007B
L007F:
	cpi	YL,0x01
	brne	L0086
	clr	TMP2
L0082:
	st	X+,TMP2
	inc	TMP2
	dec	YH
	brne	L0082
L0086:
	cpi	YL,0x02
	brne	L008C
L0088:
	ldi	r16,0x20
	st	X+,r16
	dec	YH
	brne	L0088
L008C:
	cpi	YL,0x03
	brne	L0092
L008E:
	ldi	r16,0x40
	st	X+,r16
	dec	YH
	brne	L008E
L0092:
	dec	r18
	brne	L0076
//----------------------

// Clear registers
	clr	BusEx
	clr	BusData
	clr	EVal
	clr	CntEL
	clr	CntEH
	clr	CntN
	mov	ADDR,ConstC0
	clr	DivN
	clr	TMP
	clr	EIndex
	clr	ToneBits
	ori	ToneBits,0x80	; 1->ToneBits.7 (for noise generator)
	ldi	r16,0xFF
	mov	MixerABC,r16
	clr	RNGL
	clr	RNGH
	clr	OutA
	clr	OutB
	clr	OutC
	clr	TNLevel
	clr	TabP
// Set ports	
	out	PORTC,Const00
	out	PORTD,Const3F
	out	DDRD,Const00
	out	DDRC,Const00
//USART init
	clr	r16
	out	p20,r16
	ldi	r16,0x3A
	out	UBRRL,r16
	ldi	r16,0x86
	out	p20,r16
	ldi	r16,0x02
	out	UCSRA,r16
	ldi	r16,0x90
	out	UCSRB,r16
//Timer 1 init
	sbi	DDRB,b1
	sbi	DDRB,b2
	ldi	r16,0xA2
	out	TCCR1A,r16
	ldi	r16,0x19
	out	TCCR1B,r16
//set Hi PWM values
	out	OCR1AH,Const00
	out	OCR1BH,Const00
//Timer2 init
	sbi	DDRB,b3
	ldi	r16,0x79
	out	TCCR2,r16
	clr	r16
	out	ICR1H,r16
	ldi	r16,0xF3
	out	ICR1L,r16
//Ext Interrupts init
	mov	r16,Const0F	
	out	MCUCR,r16
	mov	r16,ConstC0
	out	GIFR,r16
	out	GICR,r16
//TIMSK init	
	ldi	r16,0x04
	out	TIMSK,r16

	ldi	ZH,0x02
	ldi	XH,0x02
	sei				; enable interrupts

// MAIN LOOP for updating registers
MAIN_LOOP:
	clr	r18
REG_LOOP:
	// check if register need update
	mov	XL,r18
	ori	XL,0x30
	ld	r17,X
	sbrs	r17,b0	; jump if not
	rjmp	NEXT_STEP

	st	X,Const00	; set zero (register no more needs update)
	andi	XL,0xDF		; XL-0x20
	ld	r17,X		; [X]->r17 (r17=AY register value, r18=AY register number)
	// check bits of r18 to determine the register
	sbrc	r18,b3
	rjmp	L0103
	sbrc	r18,b2
	rjmp	L00F1
	sbrc	r18,b1
	rjmp	L00E8
	sbrc	r18,b0
	rjmp	L00E4
	// register 0
	sts	DivAL,r17
	rjmp	NEXT_STEP
L00E4: 	// register 1
	and	r17,Const0F
	sts	DivAH,r17
	rjmp	NEXT_STEP
L00E8:	
	sbrc	r18,b0
	rjmp	L00ED
	// register 2
	sts	DivBL,r17
	rjmp	NEXT_STEP
L00ED:	// register 3
	and	r17,Const0F
	sts	DivBH,r17
	rjmp	NEXT_STEP
L00F1:	
	sbrc	r18,b1
	rjmp	L00FC
	sbrc	r18,b0
	rjmp	L00F8
	// register 4
	sts	DivCL,r17
	rjmp	NEXT_STEP
L00F8:  // register 5
	and	r17,Const0F
	sts	DivCH,r17
	rjmp	NEXT_STEP
L00FC:	
	sbrc	r18,b0
	rjmp	L0101
	// register 6
	andi	r17,0x1F
	mov	DivN,r17
	rjmp	NEXT_STEP
L0101:  // register 7
	com	r17
	mov	MixerABC,r17
	rjmp	NEXT_STEP
L0103:  
	sbrc	r18,b2
	rjmp	L011A
	sbrc	r18,b1
	rjmp	L0111
	sbrc	r18,b0
	rjmp	L010D
	// register 8
	andi	r17,0x1F
	sts	AmpA,r17
	rjmp	NEXT_STEP
L010D:	// register 9
	andi	r17,0x1F
	sts	AmpB,r17
	rjmp	NEXT_STEP
L0111:
	sbrc	r18,b0
	rjmp	L0117
	// register 10
	andi	r17,0x1F
	sts	AmpC,r17
	rjmp	NEXT_STEP
L0117:	// register 11
	sts	DivEL,r17
	rjmp	NEXT_STEP
L011A:
	sbrc	r18,b1
	rjmp	NEXT_STEP
	sbrc	r18,b0
	rjmp	L0121
	// register 12
	sts	DivEH,r17
	rjmp	NEXT_STEP
L0121:
	// register 13
	and	r17,Const0F
	mov	XL,r17
	ori	XL,0x40
	ld	EIndex,X
NEXT_STEP:
	inc	r18		; r18++
	sbrc	r18,b4
	rjmp	MAIN_LOOP	; r18=16 jmp to MAIN_LOOP
	rjmp	REG_LOOP

// --------- RESET HANDLER END  ------------------------------------------------------------------------------


//Timer interrupt---------------------------------------------------------------------------------------------
Timer1_interrupt:
	sei
	out	TIMSK,Const00
	out	OCR1AL,OutA
	out	OCR1BL,OutC
	out	OCR2,OutB
	push	XL		;	push X
	push	XH
	sbiw	CntEL,0x01	;	CntE-1
	brcc	L015B		;	if (C=0) jmp
	lds	CntEL,DivEL	;	DivE->CntE
	lds	CntEH,DivEH
	mov	XL,EIndex	;	EIndex -> XL
	or	XL,TabP		;	XL + TabP
	ldi	XH,0x01		;	1 -> XH
	ld	EVal,X		;	[X]->EVal
	sbrs	EVal,b5		;	if EVal=32 jmp
	rjmp	EVAL32
	clr	EVal
	rjmp	L015B
EVAL32:
	sbrs	EVal,b6		;	if EVal=64 jmp
	rjmp	EVAL64
	mov	EVal,Const0F
	rjmp	CALCEVOL	; jump to envelope volume calculation
EVAL64:
	sbiw	CntEL,0x01	;	CntE-1
	brcc	CNTE_NZ		;	if CntE>=0 jmp
	clr	CntEL		;	0->CntE
	clr	CntEH
CNTE_NZ:
	inc	TabP		;	TabP++
	sbrc	TabP,b5		;	TabP != 32 skip next	
	clr	TabP
CALCEVOL:
	lsl	XH		;	XH++// 2->XH
	mov	XL,EVal
	ld	EVal,X		;	[X]->EVal get envelope volume from volume table
L015B:
// Tonegenerator---------------------------------------------------------------------------

// Channel A -----------------------------
	lds	XL,CounterAL    ;	CounterA->X
	lds	XH,CounterAH
	sbiw	XL,0x01		;	X-1
	brcc	CH_A_END	;	if X>0 jmp
	lds	XL,DivAL	;	DivA->X
	lds	XH,DivAH
	sbrc	ToneBits,b3	;	ToneBits.3=0 jmp
	rjmp	SecondA
	// first half of tone generation perion
	ori	TNLevel,0x01	;	1->TNLevel.0 - set high level on tone of channel A
	bst	XL,0x0		;	XL.0->T
	bld	ToneBits,0x0	;	T->ToneBits.0
	ori	ToneBits,0x08	;	1->ToneBits.3
	lsr	XH		;	X>>
	ror	XL		;
	sbrc	ToneBits,b0	;	if ToneBits.0=1 jmp
	rjmp	CH_A_END
	sbiw	XL,0x01		;	X-1
	brcc	CH_A_END	;	if(X>=0) skip next
	adiw	XL,0x01		;	0->X
	rjmp	CH_A_END
SecondA:// Second half of tone generation period
	andi	TNLevel,0xFE	;	0->TNLevel.0
	andi	ToneBits,0xF6	;	0->ToneBits.0, 0->ToneBits.3
	lsr	XH              ;	X>>
	ror	XL
CH_A_END:
	sts	CounterAL,XL	;	X->CounterA
	sts	CounterAH,XH


// Channel B -----------------------------
	lds	XL,CounterBL
	lds	XH,CounterBH
	sbiw	XL,0x01
	brcc	CH_B_END
	lds	XL,DivBL
	lds	XH,DivBH
	sbrc	ToneBits,b4
	rjmp	SecondB
	ori	TNLevel,0x02
	bst	XL,b0
	bld	ToneBits,b1
	ori	ToneBits,0x10
	lsr	XH
	ror	XL
	sbrc	ToneBits,b1
	rjmp	CH_B_END
	sbiw	XL,0x01
	brcc	CH_B_END
	adiw	XL,0x01		;	0->X
	rjmp	CH_B_END
SecondB:
	andi	TNLevel,0xFD
	andi	ToneBits,0xED
	lsr	XH
	ror	XL
CH_B_END:
	sts	CounterBL,XL
	sts	CounterBH,XH


// Channel C -----------------------------
	lds	XL,CounterCL
	lds	XH,CounterCH
	sbiw	XL,0x01
	brcc	CH_C_END
	lds	XL,DivCL
	lds	XH,DivCH
	sbrc	ToneBits,b5
	rjmp	SecondC
	or	TNLevel,UnLock
	bst	XL,b0
	bld	ToneBits,b2
	ori	ToneBits,0x20
	lsr	XH
	ror	XL
	sbrc	ToneBits,b2
	rjmp	CH_C_END
	sbiw	XL,0x01
	brcc	CH_C_END
	adiw	XL,0x01		;	0->X
	rjmp	CH_C_END
SecondC:
	andi	TNLevel,0xFB
	andi	ToneBits,0xDB
	lsr	XH
	ror	XL
CH_C_END:
	sts	CounterCL,XL
	sts	CounterCH,XH
//----------------------------------------- Tone Generator END


//- NOISE GENERATOR --------------------------------------------------------------------------------
// Pseudo random number generator
	mov	XL,RNGL
	lsr	RNGH
	ror	RNGL
	bst	ToneBits,b7
	bld	RNGH,b7
	bst	RNGL,b2
	bld	XH,b0
	eor	XL,XH
	bst	XL,b0
	bld	ToneBits,b7
// Noise counter
	dec	CntN
	brpl	MIXER
	mov	CntN,DivN
	//bst	RNGL,b0 // this is not needed
	bld	TNLevel,b3
	bld	TNLevel,b4
	bld	TNLevel,b5
//------------------------------------------ Noise Generator End


// MIXER --------------------------------------------------------------------------------------
MIXER:
	mov	r16,MixerABC
	mov	r19,TNLevel
	and	r19,r16
	ldi	XH,0x02
	ldi	TMP2,0x09
	lds	OutA,AmpA
	sbrs	OutA,b4
	rjmp	L01DB
	mov	OutA,EVal
	rjmp	L01DD
L01DB:
	mov	XL,OutA
	ld	OutA,X
L01DD:
	mov	XL,r16
	and	XL,TMP2
	breq	L01EB
	cp	XL,TMP2
	breq	L01E7
	mov	XL,r19
	and	XL,TMP2
	brne	L01E6
	clr	OutA
L01E6:
	rjmp	L01EB
L01E7:
	mov	XL,r19
	and	XL,TMP2
	cpse	XL,TMP2
	clr	OutA
L01EB:
	lsl	TMP2
	lds	OutB,AmpB
	sbrs	OutB,b4
	rjmp	L01F2
	mov	OutB,EVal
	rjmp	L01F4
L01F2:
	mov	XL,OutB
	ld	OutB,X
L01F4:
	mov	XL,r16
	and	XL,TMP2
	breq	L0202
	cp	XL,TMP2
	breq	L01FE
	mov	XL,r19
	and	XL,TMP2
	brne	L01FD
	clr	OutB
L01FD:
	rjmp	L0202
L01FE:
	mov	XL,r19
	and	XL,TMP2
	cpse	XL,TMP2
	clr	OutB
L0202:
	lsl	TMP2
	lds	OutC,AmpC
	sbrs	OutC,b4
	rjmp	L0209
	mov	OutC,EVal
	rjmp	L020B
L0209:
	mov	XL,OutC
	ld	OutC,X
L020B:
	mov	XL,r16
	and	XL,TMP2
	breq	L0219
	cp	XL,TMP2
	breq	L0215
	mov	XL,r19
	and	XL,TMP2
	brne	L0214
	clr	OutC
L0214:
	rjmp	L0219
L0215:
	mov	XL,r19
	and	XL,TMP2
	cpse	XL,TMP2
	clr	OutC
//------------------------------------------------- Mixer END

L0219:
	lsl	OutB		; <<OutB (OutB x 2)
	pop	XH              ; pop X
	pop	XL
	out	TIMSK,UnLock
	reti
//---- END TIMER INTERRUPT --------------------------------------------------------------------------


//---------------------------------------------------------------------------------------------------
// USART INTERRUPT
//---------------------------------------------------------------------------------------------------
USART_Receive_Complete:
	in	TMP,UDR
	sbic	UCSRA,FE
	rjmp	L022E
	sbrc	ToneBits,b6
	rjmp	L022B
	sbrc	TMP,b7
	rjmp	L0229
	and	TMP,Const0F
	mov	ADDR,TMP
	ori	ToneBits,0x40
	rjmp	L022A
L0229:
	andi	ToneBits,0xBF
L022A:
	reti
L022B:
	andi	ToneBits,0xBF
	std	Z+0x10,TMP
	std	Z+0x30,Const0F
L022E:
	reti
//------- END TIMER INTERRUPT --------------------------------------


	.dseg
	.org	0x0060
;
DivAL:
	.byte	1
DivAH:
	.byte	1
DivBL:
	.byte	1
DivBH:
	.byte	1
DivCL:
	.byte	1
DivCH:
	.byte	1
AmpA:
	.byte	1
AmpB:
	.byte	1
AmpC:
	.byte	1
DivEL:
	.byte	1
DivEH:
	.byte	1
CounterAL:
	.byte	1
CounterAH:
	.byte	1
CounterBL:
	.byte	1
CounterBH:
	.byte	1
CounterCL:
	.byte	1
CounterCH:
	.byte	1
